/**
* \file: AilAudioSourceImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Actual implementation of AilAudioSource class (see pImpl idiom)
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_AILAUDIOSOURCEIMPL_H
#define BDCL_AILAUDIOSOURCEIMPL_H

#include <memory>
#include <adit_logging.h>
#include <AudioStreaming.h>
#include <bdcl/BaiduCoreCallbackDealer.h>
#include <bdcl/AditAudioSource.h>
#include "AilAudioConfig.h"

namespace adit { namespace utility { namespace audio {
class Backend;
class StreamStatistics;
};};};

namespace adit { namespace bdcl
{
using namespace std; // todo

/* Baidu:
 * MSG_VR_DATA - The size of each data package is 1kb. */
#define VR_PACKET_SIZE 1024

class AilAudioSourceImpl : public adit::utility::audio::Streaming
{
public:
    AilAudioSourceImpl(IAditAudioSourceCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    ~AilAudioSourceImpl();

    /* pImpl idiom: same methods as AilAudioSource */
    void setConfigItem(std::string inKey, std::string inValue);
    bool initialize();
    void teardown();
    bool captureStart();
    bool captureStop();

private:
    /* Baidu core callbacks to be consumed by MC */
    // todo reference instead of ptr?
    IAditAudioSourceCallbacks* mCallbacks;

    AilAudioSourceConfig mConfig;

    std::shared_ptr<adit::utility::audio::Backend> mAilBackend;

    CoreCallbackDealer* mCallbackDealer;

    bool mShuttingDown;

    /* AIL logging callbacks to be consumed by ADIT */
    void error(const std::string& inData) const final;
    void warning(const std::string& inData) const final;
    void info(const std::string& inData) const final;
    void debug(const std::string& inData) const final;
    adit::utility::eLogLevel checkLogLevel() const final;

    /* AIL streaming callbacks to be consumed by ADIT */
    adit::utility::audio::AudioState processing(unsigned char *in, unsigned char **out, uint32_t &frames) final;
    void statistics(const adit::utility::audio::StreamStatistics &status) final;
    void eostreaming(const adit::utility::audio::AudioError error) final;

    char captureBuff[VR_PACKET_SIZE];
    int captureOffset;

    bool mStarted;
    // todo necessary? here
//    ISendVRData* vrCapture;
};

} }

#endif /* BDCL_AILAUDIOSOURCEIMPL_H */
